/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.constants.GuiComponentType;
import noppes.npcs.api.gui.IButton;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;

public class CustomGuiButtonWrapper
extends CustomGuiComponentWrapper
implements IButton {
    int height = -1;
    String label;
    String texture;
    int textureX;
    int textureY = -1;
    int width;

    public CustomGuiButtonWrapper() {
    }

    public CustomGuiButtonWrapper(int id, String label, int x, int y) {
        this.setId(id);
        this.setLabel(label);
        this.setPos(x, y);
    }

    public CustomGuiButtonWrapper(int id, String label, int x, int y, int width, int height) {
        this(id, label, x, y);
        this.setSize(width, height);
    }

    public CustomGuiButtonWrapper(int id, String label, int x, int y, int width, int height, String texture) {
        this(id, label, x, y, width, height);
        this.textureY = 0;
        this.setTexture(texture);
    }

    public CustomGuiButtonWrapper(int id, String label, int x, int y, int width, int height, String texture, int textureX, int textureY) {
        this(id, label, x, y, width, height, texture);
        this.setTextureOffset(textureX, textureY);
    }

    @Override
    public CustomGuiComponentWrapper fromNBT(NBTTagCompound nbt) {
        super.fromNBT(nbt);
        if (nbt.func_74764_b("size")) {
            this.setSize(nbt.func_74759_k("size")[0], nbt.func_74759_k("size")[1]);
        }
        this.setLabel(nbt.func_74779_i("label"));
        if (nbt.func_74764_b("texture")) {
            this.setTexture(nbt.func_74779_i("texture"));
        }
        if (nbt.func_74764_b("texPos")) {
            this.setTextureOffset(nbt.func_74759_k("texPos")[0], nbt.func_74759_k("texPos")[1]);
        }
        return this;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosY() {
        return this.posY;
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public int getTextureX() {
        return this.textureX;
    }

    @Override
    public int getTextureY() {
        return this.textureY;
    }

    @Override
    public int getType() {
        return GuiComponentType.BUTTON.get();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean hasTexture() {
        return this.texture != null;
    }

    @Override
    public ICustomGuiComponent setId(int id) {
        this.id = id;
        return this;
    }

    @Override
    public IButton setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public IButton setSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public IButton setTexture(String texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public IButton setTextureOffset(int textureX, int textureY) {
        this.textureX = textureX;
        this.textureY = textureY;
        return this;
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        super.toNBT(nbt);
        if (this.width > 0 && this.height > 0) {
            nbt.func_74783_a("size", new int[]{this.width, this.height});
        }
        nbt.func_74778_a("label", this.label);
        if (this.hasTexture()) {
            nbt.func_74778_a("texture", this.texture);
        }
        if (this.textureX >= 0 && this.textureY >= 0) {
            nbt.func_74783_a("texPos", new int[]{this.textureX, this.textureY});
        }
        return nbt;
    }
}

